# AR Maintenance & Inspection Assistant

This portfolio project showcases a real-time AR system that assists technicians in maintaining and inspecting industrial machines. Using MQTT-based sensors, fuzzy logic evaluation, and Unity’s AR Foundation, the system visualizes live sensor data and prioritizes machines based on their condition.

This document provides a structured installation guide, an overview of the system architecture, and describes the repository structure. The folder structure aligns with project requirements at Windesheim Zwolle.

---

## 📂 Project Folder Structure

```
.root/
├── RequirementsAnalysis
├── TechnicalStackResearch│
├── SAD
├── Projectplan
│── Implementation
│   ├── Backend - Main API/
│   ├── Backend - Storage API/
│   ├── Frontend - Unity AR app/
│   ├── demo.zip
│   ├── TestStrategy
│   └── TestReport
└── README.md
```

---

## 🌐 Deployment

A live version of the backend API runs at:

```
https://api.arassistant.nl
```

It serves live SSE streams and fuzzy evaluations. You can deploy your own clone using the included Docker instructions and environment configurations.

> Note: Hosting has been halted as of June 2024 due to budget constraints. The backend can still be run locally using the provided instructions.

---

## 📁 Repository Overview

| Component         | Repository                                             | Description |
|------------------|--------------------------------------------------------|-------------|
| Backend API      | `AR-Maintenance-and-Inspection-Assistant-Backend`     | NestJS-based API connecting to MQTT broker and sensors |
| Frontend (Unity) | `AR-Maintenance-and-Inspection-Assistant-Frontend`    | Unity AR app showing live sensor and fuzzy evaluation data |
| Storage API      | `AR-Maintenance-and-Inspection-Assistant-Storage`     | Node.js + TimescaleDB service for storing historical sensor data |

---

## 🚨 Sensor mocking files note

In the demo.zip folder is a folder called `sensor_mocking_files`. This contains a quick mocking for the sensors, and does not count towards our implementation PoC and does not conribute to our portfolio. It was purely intended for debuggen and testing.

## ⚙️ Installation

> INFO: a demo file is available in the `Implementation/` folder, which contains a docker compose file and all the project files needed to run the backend locally. This guide will be based on the demo file.

### 🛠️ Prerequisites

Before starting the installation, ensure the following tools are installed:

- **Node.js** (LTS version)
- **npm** (comes with Node.js)
- **Docker & Docker Compose**
- **Unity Hub** with Unity **6000.0.46f1**
- **Git**
- Optionally: **PostgreSQL client** for TimescaleDB access

### 🐳 Docker Setup
1. Extract the `demo.zip` file from the `04. Implementation/` folder.
2. If it does not exist yet, create a docker compose file with the following content:

   ```yaml
   services:
    relational-db:
      image: postgres:17
      container_name: AR_Assistant_RelationalDB
      env_file: .env.development
      ports:
        - '5433:5432'
      volumes:
        - AR_Assistant_RelationalDB:/var/lib/postgresql/data

    timeseries-db:
      image: timescale/timescaledb:latest-pg17
      container_name: AR_Assistant_TimeseriesDB
      env_file: .env.development
      ports:
        - '5434:5432'
      volumes:
        - AR_Assistant_TimeseriesDB:/var/lib/postgresql/data

    api:
      build: './AR-Maintance-and-Inspection-Assistant-Backend-main/'
      container_name: main-api
      env_file: .env.development
      ports:
        - '3000:3000'
      depends_on:
        - mqtt5
        - timeseries-db
        - relational-db

    storage:
      build: './AR-Maintance-and-Inspection-Assistant-Storage-main/'
      container_name: storage
      env_file: .env.development
      depends_on:
        - mqtt5
        - timeseries-db

    mqtt5:
      image: eclipse-mosquitto
      container_name: mqtt5
      ports:
        - "1883:1883"
        - "9001:9001"
      volumes:
        - ./mosquitto/config:/mosquitto/config:rw
        - ./mosquitto/data:/mosquitto/data:rw
        - ./mosquitto/log:/mosquitto/log:rw
      restart: unless-stopped

    temperature_sensor:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: temperatureSensor
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=temperature
        - MACHINE_ID=1
      depends_on:
        - mqtt5

    pressure_sensor:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: pressureSensor
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=pressure
        - MACHINE_ID=1
      depends_on:
        - mqtt5

    temperature_sensor2:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: temperatureSensor2
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=temperature
        - MACHINE_ID=2
      depends_on:
        - mqtt5

    pressure_sensor2:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: pressureSensor2
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=pressure
        - MACHINE_ID=2
      depends_on:
        - mqtt5

    vibration_sensor2:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: vibrationSensor2
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=vibration
        - MACHINE_ID=2
      depends_on:
        - mqtt5

    vibration_sensor3:
      build: 
        context: ./sensor_mocking_files
        dockerfile: ./Dockerfile
      container_name: vibrationSensor3
      environment:
        - PORT=3000
        - MQTT_URL=mqtt://mqtt5:1883
        - MQTT_TOPIC=vibration
        - MACHINE_ID=3
      depends_on:
        - mqtt5

    volumes:
      AR_Assistant_RelationalDB:
        driver: local
      AR_Assistant_TimeseriesDB:
        driver: local

    networks:
      default:
        name: mqtt5-network

   ```
> NOTE: an example compose file is available in the `Implementation/` folder.

3. And again if the `.env.development` does not exists. Make one containing the following:
   ```bash
    HOST_PORT=3000
    MQTT_HOST_IP='mqtt5'

    # Database connection strings
    RELATIONAL_DATABASE_URL="postgresql://DB_User:Heelv3iligW8w00rd@relational-db:5432/AR_AssistantDB?schema=public"
    TIMESERIES_DATABASE_URL="postgresql://DB_User:Heelv3iligW8w00rd@timeseries-db:5432/AR_AssistantDB?schema=public"
    POSTGRES_USER=DB_User
    POSTGRES_PASSWORD=Heelv3iligW8w00rd
    POSTGRES_DB=AR_AssistantDB


    TIMESERIES_PGHOST=timeseries-db

   ```
4. The file structure should also be:
   ```
    root/
    ├── mosquitto
    │   ├── config
    │   |   └─── config
    │   └── data
    │   └── log
   ```
5. Run the following commands in the terminal from the directory containing the `docker-compose.yaml` file:

  ```bash
    cd AR-Maintance-and-Inspection-Assistant-Storage-main/
    npm i
    npm run build

    # go back to the root
    cd ..

    docker compose up -d --build
  ```

> NOTE: The sensor mocking, backend API and storage API should now be running. Keep in mind that the Unity frontend has to be setup separately, as described below.

### 🔧 Source Code

The source code for the repositories are also available inside their respective folders in the `04. Implementation/` directory:
* `Implementation/Backend - Main API`
* `Implementation/Backend - Storage API`

### 📱 Unity AR Frontend

> Location: `Implementation/Frontend - Unity AR app`

1. Open Unity Hub and add the project.
2. Use Unity version **6000.0.46f1**.
3. Open the `main.scene.unity` inside `Assets/Scenes/`.
4. Build to an AR-supported Android device (ARCore required).
5. When launching the app, scan one of the known reference images. 

> For generating the reference images, use this [AprilTag Generator](https://chaitanyantr.github.io/apriltag.html) with tag family `tag36h11` and id 0 for origin or 1-3 for machine info.

7. The app will connect to:

```
https://api.arassistant.nl/mqtt/{machineId}/temperature
```

> Modify `TrackedImageController.cs` if using a different endpoint.

---

## 🧪 Testing

* Backend: Unit tests are available via:

```bash
npm run test
npm run test:watch
```

* Manual testing is done via Swagger and Unity builds.

* See `TestStrategy` and `TestReport` in `Implementation/`.

> Unity uses the live version of the backend API, due to SSL certificate requirements. The backend API is hosted at `https://api.arassistant.nl`. So a local copy of the backend API is not required for testing the Unity app.

---

## 👨‍💻 Authors

* Ivan Bark
* ...
* ...
* ...

---

## 🎓 Context

Developed as a capstone project at **Windesheim Zwolle** under the module `ICT.GP.PRJCT.V22_2425`.
Coach: **...**

---

## 📜 License

This project is intended for educational use only. Commercial use is not permitted.
