const MQTT_URL = process.env.MQTT_URL;
const MQTT_TOPIC = process.env.MQTT_TOPIC;
const MACHINE_ID = process.env.MACHINE_ID;

if (!MQTT_URL || !MQTT_TOPIC || !MACHINE_ID) {
  console.error("Error: Missing required env variables: MQTT_URL, MQTT_TOPIC and MACHINE_ID.");
  process.exit(1);
}

import RealisticTemperatureSensor from './realisticTemperature_sensor.js';
import mqtt from 'mqtt';

const client = mqtt.connect(MQTT_URL)  

client.on("error" , () => {
  console.log("MQTT error occured");
  process.exit(0);
});

const sensor = new RealisticTemperatureSensor({
  interval: 1000,
  base: 15,
  amplitude: 10,
  arCoeff: 0.9999,
  noiseSigma: 0.4,
  spikeChance: 0.01,
  spikeSize: 12,
});

sensor.start(({ temperature, time }) => {
  const topic = MACHINE_ID + '/' + MQTT_TOPIC;
  const returnObj = {
    machineId: MACHINE_ID,
    sensorType: MQTT_TOPIC,
    value: temperature,
    unit: "°C",
    timestamp: new Date().toISOString()
  };
  console.log(returnObj);
  client.publish(topic, JSON.stringify(returnObj));
});
