#!/bin/sh
set -e

echo "Installing dependencies..."
npm install



echo "Waiting for PostgreSQL to be ready..."
export PGPASSWORD="$POSTGRES_PASSWORD"
until psql -h "$TIMESERIES_PGHOST" -U "$POSTGRES_USER" -d "$POSTGRES_DB" -c '\q' 2>/dev/null; do
  >&2 echo "Postgres is unavailable - sleeping"
  sleep 1
done

echo "Initializing database..."
psql -h "$TIMESERIES_PGHOST" -U "$POSTGRES_USER" -d "$POSTGRES_DB" -f "/docker-entrypoint-initdb.d/init.sql"

exec "$@"