"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const MQTT_1 = __importDefault(require("./MQTT")); // Kicks off MQTT listener
const Database_1 = __importDefault(require("./Database")); // Assuming you have a Database class for DB connection
const config_1 = require("./config");
const mqtt_instance = MQTT_1.default.getInstance();
const db = Database_1.default.getInstance();
function start() {
    mqtt_instance.Subscribe(config_1.mqttTopic);
    mqtt_instance.AddOnMessageListener(OnMessage);
}
function OnMessage(topic, message) {
    return __awaiter(this, void 0, void 0, function* () {
        const data = JSON.parse(message.toString());
        const SQL = `
    INSERT INTO sensor_data (timestamp, machine_id, sensor_type, value, unit) 
    VALUES ($1, $2, $3, $4, $5)`;
        const PARAMS = [
            data.timestamp,
            Number(data.machineId),
            data.sensorType,
            data.value,
            data.unit,
        ];
        try {
            yield db.query(SQL, PARAMS);
        }
        catch (error) {
            console.error("Error inserting data into DB:", error);
        }
    });
}
start();
process.on("SIGINT", () => __awaiter(void 0, void 0, void 0, function* () {
    mqtt_instance.close();
    db.close();
    process.exit();
}));
