-- First run init.sql to create the database and tables
-- (preferably in pgadmin or similar)

-- Enable TimescaleDB extension (must be done once per database)
CREATE EXTENSION IF NOT EXISTS timescaledb;

-- Create a table for temperature sensor data
CREATE TABLE temperature_sensor_data (
    time        TIMESTAMPTZ       NOT NULL,
    sensor_id   TEXT              NOT NULL,
    temperature DOUBLE PRECISION  NOT NULL,
    PRIMARY KEY (time, sensor_id)
);

-- Convert the table into a hypertable
SELECT create_hypertable('temperature_sensor_data', 'time', if_not_exists => TRUE);

-- Optional: Add index to help with queries by sensor_id
CREATE INDEX IF NOT EXISTS idx_temperature_sensor_id 
    ON temperature_sensor_data (sensor_id, time DESC);
