// filepath: c:\Projects\Windesheim\AR Maintenance and Inspection Assistent\AR-Maintance-and-Inspection-Assistant-Backend\src\timeseries\timeseries.service.ts
import { Injectable } from '@nestjs/common';
import { Pool } from 'pg';

@Injectable()
export class TimeseriesService {
  private pool: Pool;

  constructor() {
    this.pool = new Pool({
      connectionString: process.env.TIMESERIES_DATABASE_URL, // Use a connection string from environment variables
    });
  }

  async query(queryText: string, params?: any[]) {
    return await this.pool.query(queryText, params);
  }

  async close() {
    await this.pool.end();
  }
}
