import { Controller, Get } from '@nestjs/common';
import { TimeseriesService } from './timeseries.service';

@Controller('timeseries')
export class TimeseriesController {
  constructor(private readonly timeseriesService: TimeseriesService) {}

  @Get()
  async getTimeseriesData() {
    const result = await this.timeseriesService.query(
      'SELECT * FROM temperature_sensor_data ORDER BY time;',
    );
    return result.rows;
  }
  @Get('latest')
  async getLatestTimeseriesData() {
    const result = await this.timeseriesService.query(
      'SELECT * FROM temperature_sensor_data ORDER BY time DESC LIMIT 1;',
    );
    return result.rows[0];
  }
  @Get('latest/temperature')
  async getLatestTemperature() {
    const result = await this.timeseriesService.query(
      'SELECT temperature FROM temperature_sensor_data ORDER BY time DESC LIMIT 1;',
    );
    return result.rows[0].temperature;
  }
}
