export type GraphId = string;
export type GraphNodeId = string;
export type GraphEdgeId = string;

export enum PathType {
  DEEP = 'deep',
  SHALLOW = 'shallow',
}

export interface Graph {
  id: GraphId;
  originX: number;
  originY: number;
  originZ: number;
  scale: number;
  nodes: GraphNode[];
}

export interface GraphNode {
  id: GraphNodeId;
  label: string;
  x: number;
  y: number;
  z: number;
  graphId: string;
  edges: GraphEdge[]; // includes both A → B and B → A
}

export interface GraphEdge {
  id: GraphEdgeId;
  nodeAId: GraphNodeId;
  nodeBId: GraphNodeId;
}

export enum NearestReturnType {
  SHALLOW = 'shallow',
  DEEP = 'deep',
}

export interface NearestNodeQuery {
  x: number;
  y: number;
  z: number;
  returnType?: NearestReturnType;
}
