import { PipeTransform, Injectable, BadRequestException } from '@nestjs/common';
import {
  ALLOWED_ENDPOINTS_SENSOR,
  SensorName,
} from '../fuzzy-core/fuzzy.types';

@Injectable()
export class ParseSensorPipe implements PipeTransform {
  transform(value: string): SensorName | '#' {
    const allowed = [...ALLOWED_ENDPOINTS_SENSOR] as string[];
    if (!allowed.includes(value)) {
      throw new BadRequestException(
        `Sensor must be one of: ${allowed.join(', ')}`,
      );
    }
    return value as SensorName | '#';
  }
}
