import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import { writeFileSync } from 'fs';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  const config = new DocumentBuilder()
    .setTitle('AR Maintenance & Inspection Assistant API')
    .setDescription(
      'API documentation for the AR Maintenance & Inspection Assistant. This API provides endpoints for managing and monitoring AR devices, including MQTT subscriptions, device status, and more.',
    )
    .addTag(
      'MQTT Client Management',
      'Connect/disconnect the backend to the MQTT broker.',
    )
    .addTag(
      'MQTT Subscription Management',
      'Manage subscriptions to MQTT topics per machine and sensor.',
    )
    .addTag(
      'MQTT Debug & Testing',
      'Endpoints for SSE streaming and latest message retrieval.',
    )
    .addTag(
      'Maintenance Evaluation',
      'Endpoints for evaluating machine maintenance urgency/priority based on real-time sensor data.',
    )
    .setVersion('1.0')
    .build();

  const document = SwaggerModule.createDocument(app, config);

  SwaggerModule.setup('/', app, document);

  writeFileSync('./docs/swagger.json', JSON.stringify(document, null, 2));

  await app.listen(process.env.HOST_PORT ?? 3000);
}

void bootstrap();
