import { Observable } from 'rxjs';

export const SENSOR_NAMES = ['temperature', 'pressure', 'vibration'] as const;
export const ALLOWED_ENDPOINTS_SENSOR = [...SENSOR_NAMES, '#'] as const;

export interface RawSensorPayload {
  machineId: string;
  sensorType: string;
  value: number;
}

export type FuzzyLevel = 'Low' | 'Medium' | 'High';
export type Priority = 'Low' | 'Medium' | 'High' | 'VeryHigh';
export type SensorName = (typeof SENSOR_NAMES)[number];

export interface FuzzyRule {
  conditions: Partial<Record<SensorName, FuzzyLevel>>;
  output: Priority;
}

export interface SensorData {
  machineId: string;
  temperature?: number;
  pressure?: number;
  vibration?: number;
}

export interface PriorityList {
  priorityList: EvaluationResult[];
}

export interface EvaluationResult {
  machineId: string;
  priority: Priority;
  score: number;
}

export interface MachineConfig {
  machineId: string;
  sensors: SensorName[];
  rules: FuzzyRule[];
}
