import { FuzzyEngine } from './fuzzy.engine';
import { FLV } from './FLV';
import { FuzzyRule, SensorName } from './fuzzy.types';

export const machineConfig: Record<
  string,
  { sensors: SensorName[]; engine: FuzzyEngine }
> = {};

/**
 * Creates a fuzzy engine for a specific machine ID with the given fuzzy logic variables (FLVs) and rules.
 * @param machineId - The ID of the machine.
 * @param flvs - The fuzzy logic variables (FLVs) to use.
 * @param rules - The fuzzy rules to use.
 * @returns A new instance of FuzzyEngine.
 */
export function createEngineFor(
  machineId: string,
  flvs: Partial<Record<SensorName, FLV>>,
  rules: FuzzyRule[],
): FuzzyEngine {
  const engine = new FuzzyEngine(flvs, rules);
  machineConfig[machineId] = {
    sensors: Object.keys(flvs) as SensorName[],
    engine,
  };
  return engine;
}
