import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
// import { MachineModule } from './machine/machine.module';
// import { TimeseriesModule } from './timeseries/timeseries.module';
import { MqttModule } from './mqtt-core/mqtt.module';
import { ConfigModule } from '@nestjs/config';
import { MaintenanceModule } from './maintenance-core/maintenance.module';
import { NavigationModule } from './navigation-core/navigation.module';
import { MachineModule } from './machine/machine.module'; 

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      envFilePath: `.env.${process.env.NODE_ENV || 'development'}`,
    }),
    MqttModule,
    MaintenanceModule,
    NavigationModule,
    MachineModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
