/*
  Warnings:

  - You are about to drop the column `blocked` on the `Edge` table. All the data in the column will be lost.
  - You are about to drop the column `cost` on the `Edge` table. All the data in the column will be lost.
  - You are about to drop the column `fromId` on the `Edge` table. All the data in the column will be lost.
  - You are about to drop the column `toId` on the `Edge` table. All the data in the column will be lost.
  - A unique constraint covering the columns `[nodeAId,nodeBId]` on the table `Edge` will be added. If there are existing duplicate values, this will fail.
  - Added the required column `nodeAId` to the `Edge` table without a default value. This is not possible if the table is not empty.
  - Added the required column `nodeBId` to the `Edge` table without a default value. This is not possible if the table is not empty.
  - Added the required column `graphId` to the `Node` table without a default value. This is not possible if the table is not empty.

*/
-- DropForeignKey
ALTER TABLE "Edge" DROP CONSTRAINT "Edge_fromId_fkey";

-- DropForeignKey
ALTER TABLE "Edge" DROP CONSTRAINT "Edge_toId_fkey";

-- AlterTable
ALTER TABLE "Edge" DROP COLUMN "blocked",
DROP COLUMN "cost",
DROP COLUMN "fromId",
DROP COLUMN "toId",
ADD COLUMN     "nodeAId" TEXT NOT NULL,
ADD COLUMN     "nodeBId" TEXT NOT NULL;

-- AlterTable
ALTER TABLE "Node" ADD COLUMN     "graphId" TEXT NOT NULL,
ALTER COLUMN "label" DROP DEFAULT;

-- CreateTable
CREATE TABLE "Graph" (
    "id" TEXT NOT NULL,
    "OriginX" DOUBLE PRECISION NOT NULL,
    "OriginY" DOUBLE PRECISION NOT NULL,
    "OriginZ" DOUBLE PRECISION NOT NULL,

    CONSTRAINT "Graph_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "Edge_nodeAId_nodeBId_key" ON "Edge"("nodeAId", "nodeBId");

-- AddForeignKey
ALTER TABLE "Node" ADD CONSTRAINT "Node_graphId_fkey" FOREIGN KEY ("graphId") REFERENCES "Graph"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Edge" ADD CONSTRAINT "Edge_nodeAId_fkey" FOREIGN KEY ("nodeAId") REFERENCES "Node"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Edge" ADD CONSTRAINT "Edge_nodeBId_fkey" FOREIGN KEY ("nodeBId") REFERENCES "Node"("id") ON DELETE RESTRICT ON UPDATE CASCADE;
